/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.CECByte;
import com.quantumdata.std.CECConstants;
import java.text.DateFormatSymbols;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEC {
    public static final String getDigitalServiceIdentification(Vector<CECByte> vector, int n) {
        int n2 = vector.get(n).getData();
        boolean bl = (n2 & 0x80) == 128;
        String string = CECConstants.getDigitalBroadcastSystem(n2 &= 0x7F);
        if (bl) {
            return string + CEC.getChannelIdentifier(vector, n + 1);
        }
        switch (n2) {
            case 0: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: 
            case 26: {
                return string + " TSID=" + vector.get(n + 1) + vector.get(n + 2) + " SID=" + vector.get(n + 3) + vector.get(n + 4) + " ONID=" + vector.get(n + 5) + vector.get(n + 6);
            }
            case 1: 
            case 16: 
            case 17: 
            case 18: {
                return string + " TSID=" + vector.get(n + 1) + vector.get(n + 2) + " CID=" + vector.get(n + 3) + vector.get(n + 4) + " RSVD=" + vector.get(n + 5) + vector.get(n + 6);
            }
        }
        return "Unknown Digital Service Identifier " + vector.get(n).getData();
    }

    public static final String getChannelIdentifier(Vector<CECByte> vector, int n) {
        int n2 = vector.get(n).getData();
        int n3 = (n2 & 3) * 256 + vector.get(n + 1).getData();
        int n4 = vector.get(n + 2).getData() * 256 + vector.get(n + 3).getData();
        switch (n2 >> 2) {
            case 1: {
                return "  One part:           " + n4;
            }
            case 2: {
                return "  Two parts:          " + n3 + "." + n4;
            }
        }
        return "Unknown channel number format";
    }

    public static final String getAnalogueServiceIdentification(Vector<CECByte> vector, int n) {
        int n2 = vector.get(n + 1).getData() * 256 + vector.get(n + 2).getData();
        return "\n    Broadcast Type:   " + CECConstants.getAnalogBroadcastType(vector.get(n).getData()) + "\n    Frequency:        " + CECConstants.getAnalogFrequency(n2) + "MHz" + "\n    Broadcast System: " + CECConstants.getAnalogBroadcastSystem(vector.get(n + 3).getData());
    }

    public static final String getLanguage(Vector<CECByte> vector, int n) {
        return vector.get(n).toAscii() + vector.get(n + 1).toAscii() + vector.get(n + 2).toAscii();
    }

    public static final String getPhysicalAddress(Vector<CECByte> vector, int n) {
        int n2 = vector.get(n).getData();
        int n3 = vector.get(n + 1).getData();
        return String.format("%01X.%01X.%01X.%01X", n2 >> 4, n2 % 16, n3 >> 4, n3 % 16);
    }

    public static final String getRemainderAsString(Vector<CECByte> vector, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = vector.size();
        if (n + n2 < n3) {
            n3 = n + n2;
        }
        for (int i = n; i < n3; ++i) {
            stringBuffer.append(vector.get(i).toAscii());
        }
        return stringBuffer.toString();
    }

    public static final String getRecordSource(Vector<CECByte> vector, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (vector.get(n).getData()) {
            case 1: {
                stringBuffer.append("Own Source");
                break;
            }
            case 2: {
                stringBuffer.append("Digital Service");
                stringBuffer.append("\n  Digital Service ID: ");
                if (vector.size() >= n + 8) {
                    stringBuffer.append(CEC.getDigitalServiceIdentification(vector, n + 1));
                    break;
                }
                stringBuffer.append("ERROR: None given");
                break;
            }
            case 3: {
                stringBuffer.append("Analogue Service");
                stringBuffer.append("\n  Analogue Service ID:");
                if (vector.size() >= n + 5) {
                    stringBuffer.append(CEC.getAnalogueServiceIdentification(vector, n + 1));
                    break;
                }
                stringBuffer.append("ERROR: None given");
                break;
            }
            case 4: {
                stringBuffer.append("External Plug");
                stringBuffer.append("\n  Plug Number:        ");
                if (vector.size() >= n + 2) {
                    stringBuffer.append(vector.get(n + 1).getData());
                    break;
                }
                stringBuffer.append("ERROR: None given");
                break;
            }
            case 5: {
                stringBuffer.append("External Physical Address");
                stringBuffer.append("\n  Physical Address:   ");
                if (vector.size() >= n + 3) {
                    stringBuffer.append(CEC.getPhysicalAddress(vector, n + 1));
                    break;
                }
                stringBuffer.append("ERROR: None given");
                break;
            }
            default: {
                stringBuffer.append("Unknown Rec Source Type " + vector.get(n).getData());
            }
        }
        return stringBuffer.toString();
    }

    public static final String getTunerDeviceInfo(Vector<CECByte> vector, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = vector.get(n).getData();
        if ((n2 & 0x80) == 128) {
            stringBuffer.append("B");
        } else {
            stringBuffer.append("Not b");
        }
        stringBuffer.append("eing used for recording, ");
        switch (n2) {
            case 1: {
                stringBuffer.append("Not displaying Tuner");
                break;
            }
            case 2: {
                stringBuffer.append("Displaying Analogue Tuner\n");
                stringBuffer.append(CEC.getAnalogueServiceIdentification(vector, n + 1));
                break;
            }
            case 0: {
                stringBuffer.append("Displaying Digital Tuner\n");
                stringBuffer.append(CEC.getDigitalServiceIdentification(vector, n + 1));
                break;
            }
            default: {
                stringBuffer.append("Unknown Tuner Display Info 0x" + Integer.toHexString(n2));
            }
        }
        return stringBuffer.toString();
    }

    public static final String getVendorID(Vector<CECByte> vector, int n) {
        return String.format("0x%02X%02X%02X", vector.get(n).getData(), vector.get(n + 1).getData(), vector.get(n + 2).getData());
    }

    public static final String getTime(Vector<CECByte> vector, int n, boolean bl) {
        int n2 = CECConstants.convertBCDtoDecimal(vector.get(n).getData());
        int n3 = CECConstants.convertBCDtoDecimal(vector.get(n + 1).getData());
        String string = n2 + ":";
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + n3;
        if (!bl && n2 > 23 || bl && n2 > 99 || n3 > 59) {
            return "Invalid time (" + string + ")";
        }
        return string;
    }

    public static final String getDate(Vector<CECByte> vector, int n) {
        String string = "    Day of Month:     ";
        int n2 = vector.get(n).getData();
        if (n2 > 31 || n2 == 0) {
            string = string + "Invalid ";
        }
        string = string + n2;
        string = string + "\n    Month of Year:    ";
        int n3 = vector.get(n + 1).getData();
        if (n3 > 12 || n3 == 0) {
            string = string + "Invalid " + n3;
        } else {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
            String[] stringArray = dateFormatSymbols.getMonths();
            if (--n3 >= 0 && n3 <= 11) {
                string = string + stringArray[n3];
            }
        }
        string = string + "\n    Start time:       ";
        string = string + CEC.getTime(vector, n + 2, false);
        return string;
    }
}

